const {
	getEarningsByMonth,
	getHostRating,
	getBookingCountLast30Days,
	getTotalViews,
	getUpcomingBookings,
	getBookingsCountByStatus,
	getOccupancyRate,
	getBookingConversionRate,
	getNotifications,
	getMonthlyOccupancyRate,
} = require('../../services');

exports.getDashboardInfo = (req, res, next) => {
	const { userId } = req;
	const { month, date } = req.query;

	Promise.all([
		getEarningsByMonth(month, userId),
		getHostRating(userId),
		getBookingCountLast30Days(userId),
		getTotalViews(userId),
		getUpcomingBookings(userId),
		getBookingsCountByStatus(userId, date),
		getOccupancyRate(userId),
		getBookingConversionRate(userId),
		getNotifications(userId),
		getMonthlyOccupancyRate(userId),
	])
		.then(
			([
				totalEarnings,
				rating,
				bookingCount,
				totalViews,
				upcomingBookings,
				statusCounts,
				occupancyRate,
				bookingConversionRate,
				mappedNotifications,
				monthlyOccupancyRates,
			]) => {
				res.status(200).json({
					success: true,
					totalEarnings: totalEarnings.toFixed(2),
					overallRating: rating.toFixed(2),
					booking30days: bookingCount,
					totalViews,
					bookings: upcomingBookings,
					statusCounts,
					occupancyRate,
					bookingConversionRate,
					notifications: mappedNotifications,
					monthlyOccupancyRates,
				});
			},
		)
		.catch((err) => {
			next(err);
		});
};
