const { LocationTypes } = require('../../models');

exports.createLocationType = async (req, res, next) => {
	try {
		const locationType = await LocationTypes.create({
			group: req.body.group,
			name: req.body.name,
		});

		return res.status(201).json({
			success: true,
			message: 'Location type created successfully',
			data: locationType,
		});
	} catch (error) {
		next(error);
	}
};

exports.updateLocationType = async (req, res, next) => {
	try {
		const { locationTypeId } = req.params;

		const locationType = await LocationTypes.findByPk(locationTypeId);

		if (!locationType) {
			return res.status(404).json({
				success: false,
				message: 'Location type not found',
			});
		}

		locationType.group = req.body.group;
		locationType.name = req.body.name;

		await locationType.save();

		return res.status(200).json({
			success: true,
			message: 'Review updated successfully',
			review: locationType,
		});
	} catch (error) {
		next(error);
	}
};

exports.deleteLocationType = async (req, res, next) => {
	try {
		const { locationTypeId } = req.params;

		const locationType = await LocationTypes.findByPk(locationTypeId);

		if (!locationType) {
			return res.status(404).json({
				success: false,
				message: 'Location type not found',
			});
		}

		await locationType.destroy();

		return res.status(200).json({
			success: true,
			message: 'Location type deleted successfully',
		});
	} catch (error) {
		next(error);
	}
};

exports.getLocationTypes = async (req, res, next) => {
	try {
		const locationTypes = await LocationTypes.findAll();

		return res.status(200).json({
			success: true,
			data: locationTypes,
		});
	} catch (error) {
		next(error);
	}
};
