const {
	getMonthlyOccupancyRate,
	getTotalEarnings,
	getTotalBookings,
	getYearToDateSummary,
	getDailyTraffic,
	getMonthlyTraffic,
} = require('../../services');

exports.getPerformanceData = (req, res, next) => {
	const { userId } = req;
	const { filter, date, month, year } = req.query; // filter can be 'date', 'month', 'last_6_months', or 'year'

	Promise.all([
		getTotalEarnings(userId, filter, date, month, year),
		getMonthlyOccupancyRate(userId),
		getTotalBookings(userId, filter, date, month, year),
		getYearToDateSummary(userId),
		getDailyTraffic(userId),
		getMonthlyTraffic(userId),
	])
		.then(([totalEarnings, monthlyOccupancyRates, totalBookings, yearToDateSummary, dailyTraffic, monthlyTraffic]) => {
			res.status(200).json({
				success: true,
				totalEarnings,
				totalBookings,
				yearToDateSummary,
				dailyTraffic,
				monthlyTraffic,
				monthlyOccupancyRates,
			});
		})
		.catch((err) => {
			next(err);
		});
};
