const { LoginSessions } = require('../../models');
const { formatTimestamp } = require('../../util');

exports.getAllLoginSessions = (req, res, next) => {
	const { userId } = req;

	LoginSessions.findAll({
		where: { user_id: userId },
		order: [['createdAt', 'DESC']],
	})
		.then((sessions) => {
			const mappedSessions = sessions.map((session) => ({
				ipAddress: session.ip_address,
				browser: session.browser,
				os: session.os,
				device: session.device,
				address: session.address,
				latitude: session.lat,
				longitude: session.lng,
				dateTime: formatTimestamp(session.updatedAt),
			}));
			res.status(200).json({ success: true, data: mappedSessions });
		})
		.catch((err) => {
			next(err);
		});
};
