const cron = require('node-cron');
const moment = require('moment');
const { HostNotifications } = require('../models');
const { Op } = require('sequelize');

const deleteOldNotifications = () => {
	cron.schedule('* * * * *', async () => {
		try {
			const oneMonthAgo = moment().subtract(1, 'month').format('YYYY-MM-DD HH:mm:ss'); // date 1 month ago

			const deletedCount = await HostNotifications.destroy({
				where: {
					createdAt: {
						[Op.lt]: oneMonthAgo,
					},
				},
			});

			console.log(`${deletedCount} old notifications deleted.`);
		} catch (error) {
			console.error('Error running deleteOldNotifications cron job:', error.message);
		}
	});
};

module.exports = deleteOldNotifications;
