const { HostNotifications } = require('../models');

const createNotification = async (userId, bookingId, message, type = 'Check-In') => {
	try {
		const existingNotification = await HostNotifications.findOne({
			where: {
				booking_id: bookingId,
			},
		});

		if (existingNotification) {
			// console.log(`Notification for booking ID ${bookingId} already exists.`);
			return;
		}

		await HostNotifications.create({
			host_id: userId,
			booking_id: bookingId,
			notif_type: type,
			message,
			status: 'Unread',
		});

		// console.log(`Notification for booking ID ${bookingId} created.`);
	} catch (error) {
		console.error(`Error creating ${type} notification:`, error.message);
	}
};

module.exports = createNotification;
