const parseJsonSafe = (field) => {
	try {
		const firstParse = JSON.parse(field || '[]');

		if (typeof firstParse === 'string') {
			return JSON.parse(firstParse);
		}

		return firstParse;
	} catch {
		return [];
	}
};

module.exports = {
	parseJsonSafe,
};
