'use strict';

module.exports = {
	up: async (queryInterface, Sequelize) => {
		await queryInterface.createTable('listings', {
			id: {
				type: Sequelize.UUID,
				defaultValue: Sequelize.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			host_id: {
				type: Sequelize.UUID,
				allowNull: false,
			},
			name: {
				type: Sequelize.STRING(50),
				allowNull: false,
			},
			description: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			location_type: {
				type: Sequelize.JSON,
				allowNull: false,
			},
			address: {
				type: Sequelize.TEXT,
				allowNull: false,
			},
			longitude: {
				type: Sequelize.DOUBLE,
				allowNull: false,
			},
			latitude: {
				type: Sequelize.DOUBLE,
				allowNull: false,
			},
			price: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			min_capacity: {
				type: Sequelize.INTEGER,
				allowNull: false,
				defaultValue: 1,
			},
			max_capacity: {
				type: Sequelize.INTEGER,
				allowNull: false,
				defaultValue: 1,
			},
			amenities: {
				type: Sequelize.JSON,
				allowNull: true,
			},
			services: {
				type: Sequelize.JSON,
				allowNull: true,
			},
			check_in_time: {
				type: Sequelize.TIME,
				allowNull: false,
			},
			check_out_time: {
				type: Sequelize.TIME,
				allowNull: false,
			},
			cancellation_policy: {
				type: Sequelize.ENUM(
					'Cancellation and Refund Policy: 7-day full refund; 24-hour grace period (48-hour advance booking required)',
					'24-Hour Cancellation Window: Full Refund Guaranteed',
				),
				allowNull: true,
			},
			status: {
				type: Sequelize.ENUM('Active', 'Inactive'),
				allowNull: false,
				defaultValue: 'Active',
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});
	},
	down: async (queryInterface, Sequelize) => {
		await queryInterface.dropTable('listings');
	},
};
