'use strict';
module.exports = {
	up: async (queryInterface, Sequelize) => {
		await queryInterface.createTable('bookings', {
			id: {
				type: Sequelize.UUID,
				defaultValue: Sequelize.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			customer_id: {
				type: Sequelize.UUID,
				allowNull: false,
			},
			host_id: {
				type: Sequelize.UUID,
				allowNull: false,
			},
			listing_id: {
				type: Sequelize.UUID,
				allowNull: false,
			},
			booking_no: {
				type: Sequelize.STRING(20),
				allowNull: false,
			},
			check_in: {
				type: Sequelize.DATEONLY,
				allowNull: false,
			},
			check_out: {
				type: Sequelize.DATEONLY,
				allowNull: false,
			},
			pax: {
				type: Sequelize.INTEGER,
				allowNull: false,
				defaultValue: 1,
			},
			price_per_night: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			service_fee: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			add_ons_total: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			total_amount: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			payment_option: {
				type: Sequelize.ENUM('Pay Now', 'Installment'),
				allowNull: false,
			},
			payment_status: {
				type: Sequelize.ENUM('Fully Paid', 'Unpaid', 'Partially Paid'),
				allowNull: false,
				defaultValue: 'Unpaid',
			},
			amount_paid: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			balance: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			phone_no: {
				type: Sequelize.STRING(15),
				allowNull: false,
			},
			payment_method: {
				type: Sequelize.ENUM('Online', 'Cash', 'Debit/Credit'),
				allowNull: false,
			},
			card_number: {
				type: Sequelize.STRING(50),
				allowNull: true,
			},
			expiration: {
				type: Sequelize.STRING(20),
				allowNull: true,
			},
			cvv: {
				type: Sequelize.STRING(10),
				allowNull: true,
			},
			message_to_host: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			user_image: {
				type: Sequelize.STRING,
				allowNull: false,
			},
			status: {
				type: Sequelize.ENUM('Done', 'Upcoming', 'Cancelled'),
				allowNull: false,
				defaultValue: 'Upcoming',
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});
	},
	down: async (queryInterface, Sequelize) => {
		await queryInterface.dropTable('bookings');
	},
};
