'use strict';
module.exports = {
	up: async (queryInterface, Sequelize) => {
		await queryInterface.createTable('discounts', {
			id: {
				type: Sequelize.UUID,
				defaultValue: Sequelize.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			name: {
				type: Sequelize.STRING(100),
				allowNull: false,
			},
			description: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			code: {
				type: Sequelize.STRING(10),
				allowNull: false,
			},
			type: {
				type: Sequelize.ENUM('Capacity To Reach', 'By Percentage', 'Amount To Reach'),
				allowNull: true,
			},
			percentage: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: true,
			},
			num_of_pax: {
				type: Sequelize.INTEGER,
				allowNull: true,
			},
			amount: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			validity_start_date: {
				type: Sequelize.DATE,
				allowNull: true,
			},
			validity_end_date: {
				type: Sequelize.DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});
	},
	down: async (queryInterface, Sequelize) => {
		await queryInterface.dropTable('discounts');
	},
};
