'use strict';

module.exports = {
	up: async (queryInterface, Sequelize) => {
		await queryInterface.removeColumn('bookings', 'card_number');
		await queryInterface.removeColumn('bookings', 'expiration');
		await queryInterface.removeColumn('bookings', 'cvv');

		await queryInterface.changeColumn('bookings', 'user_image', {
			type: Sequelize.STRING,
			allowNull: true,
		});

		await queryInterface.changeColumn('bookings', 'status', {
			type: Sequelize.ENUM('Done', 'Upcoming', 'Cancelled', 'Pending'),
			allowNull: false,
			defaultValue: 'Pending',
		});
	},

	down: async (queryInterface, Sequelize) => {
		await queryInterface.addColumn('bookings', 'card_number', {
			type: Sequelize.STRING(50),
			allowNull: true,
		});

		await queryInterface.addColumn('bookings', 'expiration', {
			type: Sequelize.STRING(20),
			allowNull: true,
		});

		await queryInterface.addColumn('bookings', 'cvv', {
			type: Sequelize.STRING(10),
			allowNull: true,
		});

		await queryInterface.changeColumn('bookings', 'user_image', {
			type: Sequelize.STRING,
			allowNull: false,
		});

		await queryInterface.changeColumn('bookings', 'status', {
			type: Sequelize.ENUM('Done', 'Upcoming', 'Cancelled'),
			allowNull: false,
			defaultValue: 'Upcoming',
		});
	},
};
