'use strict';

module.exports = {
	up: async (queryInterface, Sequelize) => {
		await queryInterface.addColumn('users', 'address', {
			type: Sequelize.TEXT,
			allowNull: true,
		});

		await queryInterface.addColumn('users', 'address_long', {
			type: Sequelize.DOUBLE,
			allowNull: true,
		});

		await queryInterface.addColumn('users', 'address_lat', {
			type: Sequelize.DOUBLE,
			allowNull: true,
		});
	},

	down: async (queryInterface, Sequelize) => {
		await queryInterface.removeColumn('users', 'address');
		await queryInterface.removeColumn('users', 'address_long');
		await queryInterface.removeColumn('users', 'address_lat');
	},
};
