'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.addColumn(
					'users',
					'hosting_date',
					{
						type: Sequelize.DataTypes.DATEONLY,
						allowNull: true,
					},
					{ transaction: t },
				),
			]);
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.removeColumn('users', 'hosting_date', {
					transaction: t,
				}),
			]);
		});
	},
};
