'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.addColumn(
					'users',
					'language',
					{
						type: Sequelize.DataTypes.STRING,
						defaultValue: 'English',
					},
					{ transaction: t },
				),
			]);
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.removeColumn('users', 'language', {
					transaction: t,
				}),
			]);
		});
	},
};
