'use strict';

module.exports = {
	up: async (queryInterface, Sequelize) => {
		const { UUID, UUIDV4, STRING } = Sequelize;

		await queryInterface.createTable('recently_viewed_listings', {
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			listing_id: {
				type: UUID,
				allowNull: false,
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});

		await queryInterface.createTable('favorite_folders', {
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			folder_name: {
				type: STRING(100),
				allowNull: false,
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});

		await queryInterface.createTable('favorite_folder_listings', {
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			folder_id: {
				type: UUID,
				allowNull: true,
			},
			listing_id: {
				type: UUID,
				allowNull: false,
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});
	},

	down: async (queryInterface) => {
		await queryInterface.dropTable('favorite_folder_listings');
		await queryInterface.dropTable('favorite_folders');
		await queryInterface.dropTable('recently_viewed_listings');
	},
};
