'use strict';

module.exports = {
	up: async (queryInterface, Sequelize) => {
		await queryInterface.createTable('host_notifications', {
			id: {
				type: Sequelize.UUID,
				defaultValue: Sequelize.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			host_id: {
				type: Sequelize.UUID,
				allowNull: false,
			},
			booking_id: {
				type: Sequelize.UUID,
				allowNull: false,
			},
			notif_type: {
				type: Sequelize.ENUM('Check-In', 'New Booking', 'Other'),
				allowNull: false,
			},
			message: {
				type: Sequelize.STRING(100),
				allowNull: true,
			},
			status: {
				type: Sequelize.ENUM('Unread', 'Read'),
				defaultValue: 'Unread',
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});
	},

	down: async (queryInterface, Sequelize) => {
		await queryInterface.dropTable('host_notifications');
	},
};
