'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.removeColumn('listings', 'address', {
					transaction: t,
				}),
				queryInterface.addColumn(
					'listings',
					'address_country',
					{
						type: Sequelize.STRING,
						allowNull: false,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'listings',
					'address_street',
					{
						type: Sequelize.STRING,
						allowNull: false,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'listings',
					'address_apt',
					{
						type: Sequelize.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'listings',
					'address_city',
					{
						type: Sequelize.STRING,
						allowNull: false,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'listings',
					'address_state',
					{
						type: Sequelize.STRING,
						allowNull: false,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'listings',
					'address_zip',
					{
						type: Sequelize.STRING,
						allowNull: false,
					},
					{ transaction: t },
				),
			]);
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.addColumn(
					'listings',
					'address',
					{
						type: Sequelize.DataTypes.TEXT,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.removeColumn('listings', 'address_country', { transaction: t }),
				queryInterface.removeColumn('listings', 'address_street', { transaction: t }),
				queryInterface.removeColumn('listings', 'address_apt', { transaction: t }),
				queryInterface.removeColumn('listings', 'address_city', { transaction: t }),
				queryInterface.removeColumn('listings', 'address_state', { transaction: t }),
				queryInterface.removeColumn('listings', 'address_zip', { transaction: t }),
			]);
		});
	},
};
