'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.removeColumn('host_registrations', 'location_address', {
					transaction: t,
				}),
				queryInterface.addColumn(
					'host_registrations',
					'address_country',
					{
						type: Sequelize.STRING,
						allowNull: false,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'host_registrations',
					'address_street',
					{
						type: Sequelize.STRING,
						allowNull: false,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'host_registrations',
					'address_apt',
					{
						type: Sequelize.STRING,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'host_registrations',
					'address_city',
					{
						type: Sequelize.STRING,
						allowNull: false,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'host_registrations',
					'address_state',
					{
						type: Sequelize.STRING,
						allowNull: false,
					},
					{ transaction: t },
				),
				queryInterface.addColumn(
					'host_registrations',
					'address_zip',
					{
						type: Sequelize.STRING,
						allowNull: false,
					},
					{ transaction: t },
				),
			]);
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.addColumn(
					'host_registrations',
					'location_address',
					{
						type: Sequelize.DataTypes.TEXT,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.removeColumn('host_registrations', 'address_country', { transaction: t }),
				queryInterface.removeColumn('host_registrations', 'address_street', { transaction: t }),
				queryInterface.removeColumn('host_registrations', 'address_apt', { transaction: t }),
				queryInterface.removeColumn('host_registrations', 'address_city', { transaction: t }),
				queryInterface.removeColumn('host_registrations', 'address_state', { transaction: t }),
				queryInterface.removeColumn('host_registrations', 'address_zip', { transaction: t }),
			]);
		});
	},
};
