'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.changeColumn(
					'discounts',
					'validity_end_date',
					{
						type: Sequelize.DATE,
						allowNull: true,
					},
					{ transaction: t },
				),
				queryInterface.createTable('payment_history', {
					id: {
						type: Sequelize.UUID,
						defaultValue: Sequelize.UUIDV4,
						allowNull: false,
						primaryKey: true,
					},
					customer_id: {
						type: Sequelize.UUID,
						allowNull: false,
					},
					host_id: {
						type: Sequelize.UUID,
						allowNull: false,
					},
					booking_id: {
						type: Sequelize.UUID,
						allowNull: false,
					},
					payout_method: {
						type: Sequelize.STRING,
						allowNull: false,
					},
					total: {
						type: Sequelize.DECIMAL(10, 2),
						allowNull: false,
					},
					expected_payout: {
						type: Sequelize.DATEONLY,
						allowNull: false,
					},
					status: {
						type: Sequelize.ENUM('Upcoming', 'Completed'),
						allowNull: false,
						defaultValue: 'Upcoming',
					},
					createdAt: {
						type: Sequelize.DATE,
						allowNull: false,
						defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
					},
					updatedAt: {
						type: Sequelize.DATE,
						allowNull: false,
						defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
					},
				}),
			]);
		});
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.sequelize.transaction((t) => {
			return Promise.all([
				queryInterface.changeColumn('discounts', 'validity_end_date', {
					type: Sequelize.DECIMAL(10, 2),
					allowNull: false,
					defaultValue: 0.0,
				}),
				queryInterface.dropTable('payment_history', { transaction: t }),
			]);
		});
	},
};
