'use strict';

module.exports = {
	up: async (queryInterface, Sequelize) => {
		await queryInterface.createTable('refresh_tokens', {
			id: {
				type: Sequelize.UUID,
				defaultValue: Sequelize.UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: Sequelize.UUID,
				allowNull: true,
			},
			token: {
				type: Sequelize.TEXT,
				allowNull: false,
			},
			expiration_date: {
				type: Sequelize.DATE,
				allowNull: false,
			},
			refresh_token: {
				type: Sequelize.TEXT,
				allowNull: false,
			},
			refresh_token_expiration_date: {
				type: Sequelize.DATE,
				allowNull: false,
			},
			browser: {
				type: Sequelize.STRING,
				allowNull: false,
			},
			os: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			device: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			device_id: {
				type: Sequelize.TEXT,
				allowNull: true,
			},
			createdAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP'),
			},
			updatedAt: {
				type: Sequelize.DATE,
				allowNull: false,
				defaultValue: Sequelize.literal('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
			},
		});
	},

	down: async (queryInterface, Sequelize) => {
		await queryInterface.dropTable('refresh_tokens');
	},
};
