const { UUID, UUIDV4, DECIMAL, STRING, INTEGER } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const BookingAddOns = sequelize.define(
		'BookingAddOns',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			booking_id: {
				type: UUID,
				allowNull: false,
			},
			add_on_name: {
				type: STRING(100),
				allowNull: false,
			},
			quantity: {
				type: INTEGER,
				allowNull: false,
				defaultValue: 1,
			},
			price: {
				type: DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
			total_amount: {
				type: DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
		},
		{
			tableName: 'booking_add_ons',
			timestamps: true,
		},
	);

	return BookingAddOns;
};
