const { UUID, UUIDV4 } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const ConversationMembers = sequelize.define(
		'ConversationMembers',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			convo_id: {
				type: UUID,
				allowNull: false,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
		},
		{
			tableName: 'conversation_members',
			timestamps: true,
		},
	);

	ConversationMembers.associate = function (models) {
		ConversationMembers.belongsTo(models.Conversations, {
			foreignKey: 'convo_id',
			as: 'conversations',
		});

		ConversationMembers.belongsTo(models.Users, {
			foreignKey: 'user_id',
			as: 'user_members',
		});
	};

	return ConversationMembers;
};
