const { UUID, UUIDV4, STRING, TEXT } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const Users = sequelize.define(
		'DeletedAccounts',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			firstname: {
				type: STRING,
				allowNull: true,
			},
			lastname: {
				type: STRING,
				allowNull: true,
			},
			email_address: {
				type: STRING,
				allowNull: true,
			},
			reason: {
				type: TEXT,
				allowNull: false,
			},
		},
		{
			tableName: 'deleted_accounts',
			timestamps: true,
			updatedAt: false,
		},
	);

	return Users;
};
