const { UUID, UUIDV4, TEXT, INTEGER } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const HostReviews = sequelize.define(
		'HostReviews',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			host_id: {
				type: UUID,
				allowNull: false,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			rating: {
				type: INTEGER,
				allowNull: false,
			},
			content: {
				type: TEXT,
				allowNull: true,
			},
		},
		{
			tableName: 'host_reviews',
			timestamps: true,
		},
	);

	HostReviews.associate = function (models) {
		HostReviews.hasMany(models.HostReviews, {
			foreignKey: 'user_id',
			as: 'hostReviews',
		});
	};

	HostReviews.associate = function (models) {
		HostReviews.belongsTo(models.Users, {
			foreignKey: 'user_id',
		});
	};

	return HostReviews;
};
