const { UUID, UUIDV4, DECIMAL, STRING } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const HostRegistrationAddOns = sequelize.define(
		'HostRegistrationAddOns',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			host_registration_id: {
				type: UUID,
				allowNull: false,
			},
			add_on_name: {
				type: STRING(100),
				allowNull: false,
			},
			price: {
				type: DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
		},
		{
			tableName: 'host_registration_add_ons',
			timestamps: true,
		},
	);

	return HostRegistrationAddOns;
};
