const { UUID, UUIDV4, STRING, ENUM } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const HostRegistrationFiles = sequelize.define(
		'HostRegistrationFiles',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			host_registration_id: {
				type: UUID,
				allowNull: false,
			},
			file_type: {
				type: ENUM('Listing Images', 'Supporting Documents'),
				allowNull: false,
			},
			file: {
				type: STRING,
				allowNull: false,
			},
		},
		{
			tableName: 'host_registration_files',
			timestamps: true,
		},
	);

	HostRegistrationFiles.associate = function (models) {
		HostRegistrationFiles.belongsTo(models.HostsRegistrations, {
			foreignKey: 'host_registration_id',
		});
	};

	return HostRegistrationFiles;
};
