const { UUID, UUIDV4, STRING, TEXT, INTEGER, ENUM, JSON, BOOLEAN, DECIMAL, TIME } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const HostsRegistrations = sequelize.define(
		'HostsRegistrations',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			city_to_hosts: {
				type: STRING,
				allowNull: false,
			},
			languages: {
				type: JSON,
				allowNull: true,
			},
			is_partner_org: {
				type: BOOLEAN,
				defaultValue: false,
			},
			themes: {
				type: JSON,
				allowNull: true,
			},
			duration: {
				type: INTEGER,
				allowNull: false,
			},
			location_type: {
				type: JSON,
				allowNull: false,
			},
			location_description: {
				type: TEXT,
				allowNull: true,
			},
			hosting_type: {
				type: ENUM('Self', 'Team'),
				allowNull: false,
			},
			selfie_image: {
				type: STRING,
				allowNull: true,
			},
			about_me: {
				type: TEXT,
				allowNull: true,
			},
			address_country: {
				type: STRING,
				allowNull: false,
			},
			address_street: {
				type: STRING,
				allowNull: false,
			},
			address_apt: {
				type: STRING,
				allowNull: true,
			},
			address_city: {
				type: STRING,
				allowNull: false,
			},
			address_state: {
				type: STRING,
				allowNull: false,
			},
			address_zip: {
				type: STRING,
				allowNull: false,
			},
			location_long: {
				type: DECIMAL(10, 2),
				allowNull: true,
			},
			location_lat: {
				type: DECIMAL(10, 2),
				allowNull: true,
			},
			amenities: {
				type: JSON,
				allowNull: true,
			},
			services: {
				type: JSON,
				allowNull: true,
			},
			listing_name: {
				type: STRING,
				allowNull: false,
			},
			listing_description: {
				type: TEXT,
				allowNull: true,
			},
			listing_images: {
				type: JSON,
				allowNull: true,
			},
			capacity: {
				type: INTEGER,
				allowNull: false,
			},
			individual_rate: {
				type: DECIMAL(10, 2),
				allowNull: false,
			},
			check_in_time: {
				type: TIME,
				allowNull: false,
			},
			check_out_time: {
				type: TIME,
				allowNull: false,
			},
			cancellation_policy: {
				type: ENUM(
					'Cancellation and Refund Policy: 7-day full refund; 24-hour grace period (48-hour advance booking required)',
					'24-Hour Cancellation Window: Full Refund Guaranteed',
				),
				allowNull: true,
			},
			status: {
				type: ENUM('Approved', 'Rejected', 'Pending'),
				allowNull: false,
				defaultValue: 'Pending',
			},
		},
		{
			tableName: 'host_registrations',
			timestamps: true,
		},
	);

	HostsRegistrations.associate = (models) => {
		HostsRegistrations.hasMany(models.HostRegistrationFiles, {
			foreignKey: 'host_registration_id',
			as: 'files',
		});
	};

	return HostsRegistrations;
};
