const { UUID, UUIDV4, DECIMAL, STRING } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const ListingAddOns = sequelize.define(
		'ListingAddOns',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			listing_id: {
				type: UUID,
				allowNull: false,
			},
			add_on_name: {
				type: STRING(100),
				allowNull: false,
			},
			price: {
				type: DECIMAL(10, 2),
				allowNull: false,
				defaultValue: 0.0,
			},
		},
		{
			tableName: 'listing_add_ons',
			timestamps: true,
		},
	);

	return ListingAddOns;
};
