const { UUID, UUIDV4, STRING } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const ListingImages = sequelize.define(
		'ListingImages',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			listing_id: {
				type: UUID,
				allowNull: false,
			},
			category: {
				type: STRING,
				allowNull: true,
			},
			image: {
				type: STRING,
				allowNull: false,
			},
		},
		{
			tableName: 'listing_images',
			timestamps: true,
		},
	);

	ListingImages.associate = function (models) {
		ListingImages.belongsTo(models.Listings, {
			foreignKey: 'listing_id',
		});
	};

	return ListingImages;
};
