const { UUID, UUIDV4, STRING } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const LocationTypes = sequelize.define(
		'LocationTypes',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			group: {
				type: STRING,
				allowNull: false,
			},
			name: {
				type: STRING,
				allowNull: false,
			},
		},
		{
			tableName: 'location_types',
			timestamps: false,
		},
	);

	return LocationTypes;
};
