const { UUID, UUIDV4, TEXT, DOUBLE, STRING } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const LoginSessions = sequelize.define(
		'LoginSessions',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			user_id: {
				type: UUID,
				allowNull: false,
			},
			address: {
				type: TEXT,
				allowNull: true,
			},
			lng: {
				type: DOUBLE,
				allowNull: true,
			},
			lat: {
				type: DOUBLE,
				allowNull: true,
			},
			ip_address: {
				type: STRING,
				allowNull: false,
			},
			browser: {
				type: STRING,
				allowNull: false,
			},
			os: {
				type: TEXT,
				allowNull: true,
			},
			device: {
				type: TEXT,
				allowNull: true,
			},
		},
		{
			tableName: 'login_sessions',
			timestamps: true,
		},
	);

	return LoginSessions;
};
