const { UUID, UUIDV4, STRING } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const MessageAttachments = sequelize.define(
		'MessageAttachments',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			message_id: {
				type: UUID,
				allowNull: false,
			},
			image: {
				type: STRING,
				allowNull: false,
			},
		},
		{
			tableName: 'message_attachments',
			timestamps: true,
		},
	);

	return MessageAttachments;
};
