const { UUID, UUIDV4, TEXT, BOOLEAN } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const Messages = sequelize.define(
		'Messages',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			convo_id: {
				type: UUID,
				allowNull: false,
			},
			sender_id: {
				type: UUID,
				allowNull: false,
			},
			content: {
				type: TEXT,
				allowNull: false,
			},
			is_seen: {
				type: BOOLEAN,
				allowNull: false,
				defaultValue: false,
			},
		},
		{
			tableName: 'messages',
			timestamps: true,
		},
	);

	Messages.associate = function (models) {
		Messages.belongsTo(models.Users, {
			foreignKey: 'sender_id',
			as: 'sender',
		});
	};

	return Messages;
};
