const { UUID, UUIDV4, TEXT, DATE, STRING, BOOLEAN } = require('sequelize');

module.exports = (sequelize, DataTypes) => {
	const PasswordResetTokens = sequelize.define(
		'PasswordResetTokens',
		{
			id: {
				type: UUID,
				defaultValue: UUIDV4,
				allowNull: false,
				primaryKey: true,
			},
			email: {
				type: STRING,
				allowNull: false,
			},
			token: {
				type: TEXT,
				allowNull: false,
			},
			expiry: {
				type: DATE,
				allowNull: false,
			},
			resent: {
				type: BOOLEAN,
				allowNull: true,
			},
		},
		{
			tableName: 'password_reset_tokens',
			timestamps: false,
		},
	);

	return PasswordResetTokens;
};
