'use strict';

const fs = require('fs');
const path = require('path');
const Sequelize = require('sequelize');
require('dotenv').config();

const basename = path.basename(__filename);
const env = process.env.NODE_ENV || 'development';
const config = require(path.join(__dirname, '../config/config.js'))[env];
const db = {};

let sequelize;
if (config.use_env_variable) {
	sequelize = new Sequelize(process.env[config.use_env_variable], config);
} else {
	sequelize = new Sequelize(config.database, config.username, config.password, config);
}

fs.readdirSync(__dirname)
	.filter((file) => file.indexOf('.') !== 0 && file !== basename && file.slice(-3) === '.js')
	.forEach((file) => {
		const model = require(path.join(__dirname, file))(sequelize, Sequelize.DataTypes);
		db[model.name] = model;
	});

Object.keys(db).forEach((modelName) => {
	if (db[modelName].associate) {
		db[modelName].associate(db);
	}
});

module.exports = {
	Users: db.Users,
	BookingAddOns: db.BookingAddOns,
	Bookings: db.Bookings,
	CustomerReviews: db.CustomerReviews,
	Discounts: db.Discounts,
	HostsAddOns: db.HostsAddOns,
	HostsRegistrations: db.HostsRegistrations,
	HostRegistrationFiles: db.HostRegistrationFiles,
	HostReviews: db.HostReviews,
	HostRegistrationAddOns: db.HostRegistrationAddOns,
	ListingImages: db.ListingImages,
	Listings: db.Listings,
	ListingAddOns: db.ListingAddOns,
	ListingReviews: db.ListingReviews,
	LocationTypes: db.LocationTypes,
	Conversations: db.Conversations,
	ConversationMembers: db.ConversationMembers,
	Messages: db.Messages,
	MessageAttachments: db.MessageAttachments,
	DeletedAccounts: db.DeletedAccounts,
	UsersFlags: db.UsersFlags,
	UsersPrivacyFlags: db.UsersPrivacyFlags,
	RecentlyViewedListings: db.RecentlyViewedListings,
	FavoriteFolderListings: db.FavoriteFolderListings,
	FavoriteFolders: db.FavoriteFolders,
	HostNotifications: db.HostNotifications,
	PasswordResetTokens: db.PasswordResetTokens,
	PaymentHistory: db.PaymentHistory,
	LoginSessions: db.LoginSessions,
	RefreshTokens: db.RefreshTokens,
	sequelize,
	Sequelize,
};
