const express = require('express');
const { body } = require('express-validator');
const { validation, isAuth } = require('../../../middlewares');
const { createBooking, getAllMyBookings, cancelBooking } = require('../../../controllers/customers/bookings');

const router = express.Router();

router.post(
	'/',
	isAuth,
	[
		body('listingId').notEmpty(),
		body('checkIn').notEmpty(),
		body('checkOut').notEmpty(),
		body('pax').notEmpty(),
		body('paymentOption').notEmpty(),
		body('phoneNo').notEmpty(),
		body('paymentMethod').notEmpty(),
		body('amountPaid').notEmpty(),
		body('addOns.*.name').notEmpty().withMessage('Add-on name is required.'),
		body('addOns.*.price').isNumeric().withMessage('Add-on price must be a number.'),
		body('addOns.*.quantity')
			.isInt({ min: 1 })
			.withMessage('Add-on quantity must be an integer greater than or equal to 1.'),
	],
	validation,
	createBooking,
);

router.get('/', isAuth, getAllMyBookings);

router.patch('/:bookingNumber', isAuth, cancelBooking);

module.exports = router;
