const express = require('express');
const router = express.Router();

const bookingsRoute = require('./bookings-route/bookings');
const listingRoutes = require('./listing-route/listings');
const listingImagesRoutes = require('./listing-route/images');
const recentlyViewedRoutes = require('./listing-route/recent');
const reviewRoutes = require('./listing-route/reviews');
const hostReviewRoutes = require('./host-review-route/host-reviews');
const locationTypesRoutes = require('./location-types-route/location-type');
const hostProfileRoutes = require('./host-profile-route/host-profile');
const messageHostProfileRoutes = require('./messages-route/host-profile');
const favoritesRoutes = require('./favorites-route/favorites');
const discountRoutes = require('./discounts-route/discounts');
const paymentHistoryRoutes = require('./payments-history-route/payments');

router.use('/bookings', bookingsRoute);
router.use('/listings', listingRoutes);
router.use('/listings-images', listingImagesRoutes);
router.use('/listings-recent', recentlyViewedRoutes);
router.use('/reviews', reviewRoutes);
router.use('/host-reviews', hostReviewRoutes);
router.use('/location-types', locationTypesRoutes);
router.use('/host-profile', hostProfileRoutes);
router.use('/messages/host-profile', messageHostProfileRoutes);
router.use('/favorites', favoritesRoutes);
router.use('/discounts', discountRoutes);
router.use('/payment-history', paymentHistoryRoutes);

module.exports = router;
