const express = require('express');
const router = express.Router();
const { body } = require('express-validator');
const { validation, isAuth } = require('../../../middlewares');
const { getReviews, updateReview, deleteReview, createReview } = require('../../../controllers/host/customer-reviews');

router.get('/:customerId', getReviews);
router.post(
	'/:customerId',
	isAuth,
	[
		body('rating')
			.isInt({
				min: 1,
				max: 5,
			})
			.withMessage('Please provide rating'),
		body('content')
			.isString()
			.optional({
				values: 'falsy',
			})
			.withMessage('Please provide content'),
	],
	validation,
	createReview,
);
router.patch(
	'/:reviewId',
	isAuth,
	[
		body('rating')
			.isInt({
				min: 1,
				max: 5,
			})
			.optional()
			.withMessage('Rating must be an integer between 1 and 5'),
		body('content')
			.isString()
			.optional({
				values: 'falsy',
			})
			.withMessage('Please provide content'),
	],
	validation,
	updateReview,
);
router.delete('/:reviewId', isAuth, deleteReview);

module.exports = router;
