const express = require('express');
const router = express.Router();

const hostApplyRoute = require('./apply-route/apply');
const bookingsRoute = require('./bookings-route/bookings');
const listingRoute = require('./listing-route/listing');
const reviewsRoute = require('./listing-route/reviews');
const locationTypesRoute = require('./location-types-route/location-type');
const customerReviews = require('./customer-reviews/reviews');
const dashboardRoute = require('./dashboard-route/dashboard');
const performanceRoute = require('./performance-route/performance');
const calendarRoute = require('./calendar-route/calendar');

router.use('/application', hostApplyRoute);
router.use('/bookings', bookingsRoute);
router.use('/listings', listingRoute);
router.use('/reviews', reviewsRoute);
router.use('/location-types', locationTypesRoute);
router.use('/customer-reviews', customerReviews);
router.use('/dashboard', dashboardRoute);
router.use('/performance', performanceRoute);
router.use('/calendar', calendarRoute);

module.exports = router;
