const express = require('express');
const router = express.Router();
const { body } = require('express-validator');
const { validation, isAuth } = require('../../../middlewares');
const {
	getLocationTypes,
	createLocationType,
	updateLocationType,
	deleteLocationType,
} = require('../../../controllers/host/location-types');

router.get('/', getLocationTypes);
router.post(
	'/',
	isAuth,
	[
		body('group').notEmpty().withMessage('Group must not be an empty').isString().withMessage('Name must be a string'),
		body('name').notEmpty().withMessage('Name must not be empty').isString().withMessage('Name must be a string'),
	],
	validation,
	createLocationType,
);
router.patch(
	'/:locationTypeId',
	isAuth,
	[
		body('group')
			.notEmpty()
			.withMessage('Group must not be an empty')
			.isString()
			.withMessage('Name must be a string')
			.optional(),
		body('name')
			.notEmpty()
			.withMessage('Name must not be empty')
			.isString()
			.withMessage('Name must be a string')
			.optional(),
	],
	validation,
	updateLocationType,
);
router.delete('/:locationTypeId', isAuth, deleteLocationType);

module.exports = router;
