const express = require('express');
const { updateFlags, getFlags } = require('../../../controllers/users/flags');
const { isAuth, validation } = require('../../../middlewares');
const { body } = require('express-validator');

const router = express.Router();

router.patch(
	'/',
	isAuth,
	[
		body('stayfinderLatestFeatures').optional().isBoolean(),
		body('stayfinderLatestFeaturesEmail').optional().isBoolean(),
		body('stayfinderLatestFeaturesMessage').optional().isBoolean(),
		body('travelAdvice').optional().isBoolean(),
		body('travelAdviceEmail').optional().isBoolean(),
		body('travelAdviceMessage').optional().isBoolean(),
		body('accountManagementAndGuidelines').optional().isBoolean(),
		body('accountManagementAndGuidelinesEmail').optional().isBoolean(),
		body('accountManagementAndGuidelinesMessage').optional().isBoolean(),
		body('travelersAndHostMessages').optional().isBoolean(),
		body('travelersAndHostMessagesEmail').optional().isBoolean(),
		body('travelersAndHostMessagesMessage').optional().isBoolean(),
	],
	validation,
	updateFlags,
);

router.get('/', isAuth, getFlags);

module.exports = router;
