const express = require('express');
const router = express.Router();

const accountsRoute = require('./accounts/accounts');
const chatSystemRoute = require('./chat-system-route/chat-system');
const flagsRoute = require('./flags-route/flags');
const privacyFlagsRoute = require('./flags-route/privacy-flags');
const profileRoutes = require('./profiles-route/profiles');
const loginSessionRoute = require('./login-sessions/login-sessions');
const refreshTokenRoute = require('./refresh-token/refresh-token');

router.use('/accounts', accountsRoute);
router.use('/flags', flagsRoute);
router.use('/privacy-flags', privacyFlagsRoute);
router.use('/chat', chatSystemRoute);
router.use('/profiles', profileRoutes);
router.use('/sessions', loginSessionRoute);
router.use('/refresh-token', refreshTokenRoute);

module.exports = router;
