'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
	async up(queryInterface, Sequelize) {
		return queryInterface.bulkInsert('discounts', [
			{
				id: generateRandomId(),
				name: "Valentine's Day Promo",
				description: 'Special offer for couples',
				code: generateRandomCode(),
				type: 'By Percentage',
				percentage: 15.0,
				num_of_pax: 2,
				amount: 0.0,
				...generateValidityDates({ started: true, ended: true }),
				createdAt: new Date(),
				updatedAt: new Date(),
			},
			{
				id: generateRandomId(),
				name: 'Weekend Flash Sale',
				description: 'Limited time discounts',
				code: generateRandomCode(),
				type: 'By Percentage',
				percentage: 20.0,
				num_of_pax: 0,
				amount: 0.0,
				...generateValidityDates({ started: true, ended: false }),
				createdAt: new Date(),
				updatedAt: new Date(),
			},
			{
				id: generateRandomId(),
				name: 'January Blues Buster',
				description: 'Deals to beat the post-holiday blues',
				code: generateRandomCode(),
				type: 'Amount To Reach',
				percentage: 0.0,
				num_of_pax: 0,
				amount: 100.0,
				...generateValidityDates({ started: true, ended: true }),
				createdAt: new Date(),
				updatedAt: new Date(),
			},
			{
				id: generateRandomId(),
				name: 'Spring Break Special',
				description: 'Plan your spring getaway now!',
				code: generateRandomCode(),
				type: 'By Percentage',
				percentage: 10.0,
				num_of_pax: 0,
				amount: 0.0,
				...generateValidityDates({ started: false, ended: false }),
				createdAt: new Date(),
				updatedAt: new Date(),
			},
			{
				id: generateRandomId(),
				name: 'Anniversary Discount',
				description: 'Celebrate with us and save!',
				code: generateRandomCode(),
				type: 'By Percentage',
				percentage: 5.0,
				amount: 0.0,
				...generateValidityDates({ started: true, ended: false }),
				createdAt: new Date(),
				updatedAt: new Date(),
			},
		]);
	},

	async down(queryInterface, Sequelize) {
		return queryInterface.bulkDelete('discounts', null, {});
	},
};

function generateRandomId() {
	return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
		var r = (Math.random() * 16) | 0,
			v = c == 'x' ? r : (r & 0x3) | 0x8;
		return v.toString(16);
	});
}

function generateRandomCode() {
	let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
	let code = '';
	for (let i = 0; i < 3; i++) {
		code += characters.charAt(Math.floor(Math.random() * 26));
	}
	for (let i = 0; i < 2; i++) {
		code += characters.charAt(26 + Math.floor(Math.random() * 10));
	}
	return code;
}

function generateValidityDates({ started, ended }) {
	const currentDate = new Date();
	let startDate, endDate;

	if (started && ended) {
		startDate = new Date(currentDate.getFullYear(), currentDate.getMonth() - 2, currentDate.getDate());
		endDate = new Date(currentDate.getFullYear(), currentDate.getMonth() - 1, currentDate.getDate());
	} else if (started && !ended) {
		startDate = new Date(currentDate.getFullYear(), currentDate.getMonth() - 1, currentDate.getDate());
		endDate = new Date(currentDate.getFullYear(), currentDate.getMonth() + 1, currentDate.getDate());
	} else if (!started && !ended) {
		startDate = new Date(currentDate.getFullYear(), currentDate.getMonth() + 1, currentDate.getDate());
		endDate = new Date(currentDate.getFullYear(), currentDate.getMonth() + 2, currentDate.getDate());
	} else {
		throw new Error('Invalid combination of started and ended');
	}

	return {
		validity_start_date: startDate.toISOString().split('T')[0],
		validity_end_date: endDate.toISOString().split('T')[0],
	};
}
