const { ensureConversationExists, saveMessage, findOrCreateConversation } = require('./chatSystemServices');
const { getAllConvoByUser } = require('./conversationServices');
const {
	getEarningsByMonth,
	getHostRating,
	getBookingCountLast30Days,
	getTotalViews,
	getUpcomingBookings,
	getBookingsCountByStatus,
	getOccupancyRate,
	getBookingConversionRate,
	getNotifications,
	getMonthlyOccupancyRate,
} = require('./dashboardServices');
const {
	checkUserStatus,
	createHostRegistration,
	updateUserStatus,
	findHostRegistrationById,
	approveHostRegistration,
	createListingAddOns,
} = require('./hostRegistrationServices');
const { saveListingImages } = require('./imageServices');
const { createListing } = require('./listingServices');
const {
	getTotalEarnings,
	getTotalBookings,
	getYearToDateSummary,
	getDailyTraffic,
	getMonthlyTraffic,
} = require('./performanceServices');
const { updateUserHostStatus } = require('./userServices');

module.exports = {
	checkUserStatus,
	createHostRegistration,
	updateUserStatus,
	findHostRegistrationById,
	approveHostRegistration,
	saveListingImages,
	createListing,
	updateUserHostStatus,
	ensureConversationExists,
	saveMessage,
	getAllConvoByUser,
	findOrCreateConversation,
	createListingAddOns,
	getEarningsByMonth,
	getHostRating,
	getBookingCountLast30Days,
	getTotalViews,
	getUpcomingBookings,
	getBookingsCountByStatus,
	getOccupancyRate,
	getBookingConversionRate,
	getNotifications,
	getMonthlyOccupancyRate,
	getTotalEarnings,
	getTotalBookings,
	getYearToDateSummary,
	getDailyTraffic,
	getMonthlyTraffic,
};
