const LOGO_URL = 'https://api.aircamp.ph/public/logo/aircamp.png';
const FRONT_END_RESET_PASSWORD_URL = 'https://api.aircamp.ph/reset-password';

exports.resetPasswordEmailTemplate = (userName, token) => {
	return `
    <!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Password Reset</title>
  </head>
  <body
    style="
      font-family: Arial, Helvetica, sans-serif, sans-serif;
      margin: 0;
      padding: 20px;
    "
  >
    <div
      style="
        display: flex;
      "
    >
      <div style="margin:auto">
        <div>
          <img
            src="${LOGO_URL}"
            style="height: 60px"
          />
        </div>
        <p style="margin-left: 50px">Dear ${userName},</p>
        <p style="margin-left: 50px; margin-top: 40px; margin-bottom: 40px">
          We've received a request to reset your password. <br />To confirm and
          create a new password, please click the link below:
        </p>
        <a
          href="${FRONT_END_RESET_PASSWORD_URL + '/?token=' + token}"
          style="
            margin-left: 50px;
            text-decoration: none;
            color: white;
            font-weight: bold;
            background-color: #20653d;
            padding: 10px 20px;
            border-radius: 50px;
          "
          >Reset Password</a
        >
        <p style="margin-left: 50px; margin-top: 40px">
          If you did not request a password reset, please ignore this email<br/> or
          contact our support team for assistance.
        </p>
        <p style="margin-left: 50px; margin-top: 40px">
          Best Regards,<br />Aircamp Team
        </p>
      </div>
    </div>
  </body>
</html>`;
};
