const multer = require('multer');

const uploadFolders = {
	selfieImg: 'public/host-uploads',
	supportingDocs: 'public/host-uploads',
	listingImgs: 'public/host-uploads',
	profileImg: 'public/user-uploads',
	validIdImg: 'public/user-uploads',
	messageAttachments: 'public/convo-uploads',
};

const fileStorage = multer.diskStorage({
	destination: (req, file, cb) => {
		const uploadFolder = uploadFolders[file.fieldname];

		if (uploadFolder) {
			cb(null, uploadFolder);
		} else {
			cb(new Error('Invalid fieldname'), false);
		}
	},
	filename: (req, file, cb) => {
		const date = new Date();
		const formattedDate = date.toISOString().replace(/:/g, '-') + '-';
		cb(null, formattedDate + file.originalname);
	},
});

const fileFilter = (req, file, cb) => {
	if (
		file.mimetype === 'image/png' ||
		file.mimetype === 'image/jpg' ||
		file.mimetype === 'image/jpeg' ||
		file.mimetype === 'image/webp' ||
		file.mimetype === 'application/vnd.openxmlformats-officedocument.wordprocessingml.document' || // DOCX
		file.mimetype === 'application/pdf'
	) {
		cb(null, true);
	} else {
		cb(new Error('File format not supported'), false);
	}
};

const multerConfig = (req, res, next) => {
	multer({
		storage: fileStorage,
		fileFilter: fileFilter,
		limits: {
			fileSize: 5 * 1024 * 1024, // 5MB
		},
	}).fields([
		{
			name: 'selfieImg',
			maxCount: 1,
		},
		{
			name: 'supportingDocs',
			maxCount: 5,
		},
		{
			name: 'listingImgs',
			maxCount: 10,
		},
		{
			name: 'profileImg',
			maxCount: 1,
		},
		{
			name: 'validIdImg',
			maxCount: 1,
		},
		{
			name: 'messageAttachments',
			maxCount: 10,
		},
	])(req, res, next);
};

module.exports = multerConfig;
