function paginate(items, currentPage = 1, itemsPerPage = 10) {
	const offset = (currentPage - 1) * itemsPerPage;
	const paginatedData = items.slice(offset, offset + itemsPerPage);
	const totalItems = items.length;
	const totalPages = Math.ceil(totalItems / itemsPerPage);

	return {
		data: paginatedData,
		pagination: {
			totalItems,
			currentPage,
			totalPages,
			itemsPerPage,
			hasNextPage: currentPage < totalPages,
			hasPreviousPage: currentPage > 1,
		},
	};
}

function paginateWithNextPrev(items, currentPage = 1, itemsPerPage = 10) {
	return paginate(items, currentPage, itemsPerPage);
}

module.exports = { paginate, paginateWithNextPrev };
